masterGoogleMap = {
	settings: {
		width: '100%',
		height: '600px',
		zoom: 12,
		locations: {},
		map : null,
		markers : [],
		currentPosition : {},
		currentMarker : null,
		bounds : null,
		zoom : 12,
	},
	modules: {},
	init: function (id, settings) {
	    this.modules[id] = jQuery.extend( {}, this.settings, settings );
		this.modules[id].zoom = parseInt(this.modules[id].zoom);
	},
	initMap: function() {
		jQuery.each(this.modules, function(id, module){
		    jQuery('#master-google-map'+id).width(module.width).height(module.height);
			module.map = new google.maps.Map(document.getElementById('master-google-map' + id), {
		        zoom: parseInt(module.zoom),
		        center: {lat: 50.520, lng: 30.410}
		    });
		    module.map.moduleId = id;
		    zoomChangeBoundsListener = google.maps.event.addListenerOnce(module.map, 'bounds_changed', function(event) {
		    	masterGoogleMap.setZoom(this.moduleId);
		    });
		    masterGoogleMap.addMarkers(id)
			masterGoogleMap.modules[id] = module;
		});
	},
	setZoom: function(moduleId) {
		if (typeof(this.modules[moduleId]) != 'undefined') {
			if (this.modules[moduleId].map.getZoom()){
				this.modules[moduleId].map.setZoom(this.modules[moduleId].zoom);
	        }
	    }
	},
	addMarkers: function(moduleId) {
		if (typeof(this.modules[moduleId]) != 'undefined') {
			module = this.modules[moduleId];
		    bounds = new google.maps.LatLngBounds();
			var isChange = false;
		    for (id in module.locations) {
		    	loc = module.locations[id];
		        if(typeof(loc.latitude) != 'undefined' && typeof(loc.longitude) != 'undefined' && loc.latitude != '' && loc.longitude != '') {
		            isChange = true; console.log(loc.address);
					var latLng = new google.maps.LatLng(parseFloat(loc.latitude), parseFloat(loc.longitude));
		            module.markers[id] = new google.maps.Marker({
		                position: latLng,
		                map: module.map,
		                icon : loc.icon_url,
		                animation: google.maps.Animation.DROP
		            });
		            var infowindow = new google.maps.InfoWindow({
		                content: loc.address,
		                maxWidth: loc.popup_width || 700
		            });
		            module.markers[id].infowindow = infowindow;
		            google.maps.event.addListener(module.markers[id], 'click', function() {
		                this.infowindow.open(module.map, this);
		            });
		            bounds.extend(latLng);
		        }
		    }
		    if(isChange) {
		        module.map.fitBounds(bounds);
		    }
		}
	}
}