<?php echo $header; ?><?php echo $column_left; ?>
<div id="content">
    <div class="page-header">
        <div class="container-fluid">
            <div class="pull-right">
                <button type="submit" form="form-master-google" data-toggle="tooltip" title="<?php echo $button_save; ?>" class="btn btn-primary"><i class="fa fa-save"></i></button>
                <a href="<?php echo $cancel; ?>" data-toggle="tooltip" title="<?php echo $button_cancel; ?>" class="btn btn-default"><i class="fa fa-reply"></i></a>
            </div>
            <h1><?php echo $heading_title; ?></h1>
            <ul class="breadcrumb">
                <?php foreach ($breadcrumbs as $breadcrumb) { ?>
                <li><a href="<?php echo $breadcrumb['href']; ?>"><?php echo $breadcrumb['text']; ?></a></li>
                <?php } ?>
            </ul>
        </div>
    </div>
    <div class="container-fluid">
        <?php if ($success) { ?>
        <div class="alert alert-success"><i class="fa fa-check-circle"></i> <?php echo $success; ?>
          <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <?php if ($error_warning) { ?>
        <div class="alert alert-danger"><i class="fa fa-exclamation-circle"></i> <?php echo $error_warning; ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php } ?>
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title"><i class="fa fa-pencil"></i> <?php echo $text_edit; ?></h3>
            </div>
            <div class="panel-body">
                <form action="<?php echo $action; ?>" method="post" enctype="multipart/form-data" id="form-master-google" class="form-horizontal">
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-name"><?php echo $entry_name; ?></label>
                        <div class="col-sm-10">
                            <input type="text" name="name" value="<?php echo $name; ?>" placeholder="<?php echo $entry_name; ?>" id="input-name" class="form-control" />
                            <?php if ($error_name) { ?>
                            <div class="text-danger"><?php echo $error_name; ?></div>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-status"><?php echo $entry_status; ?></label>
                        <div class="col-sm-10">
                            <select name="status" id="input-status" class="form-control">
                                <?php if ($status) { ?>
                                <option value="1" selected="selected"><?php echo $text_enabled; ?></option>
                                <option value="0"><?php echo $text_disabled; ?></option>
                                <?php } else { ?>
                                <option value="1"><?php echo $text_enabled; ?></option>
                                <option value="0" selected="selected"><?php echo $text_disabled; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-2 control-label" for="input-width"><?php echo $entry_width; ?>
                        </label>
                        <div class="col-sm-2">
                            <input type="text" name="width" value="<?php echo $width; ?>" placeholder="<?php echo $entry_width; ?>" id="input-width" class="form-control"/>
                            <?php if ($error_width) { ?>
                            <div class="text-danger"><?php echo $error_width; ?></div>
                            <?php } ?>
                            <span class="help-block hidden-lg"><?php echo $text_note_width;?></span>
                        </div>
                        <label class="col-sm-1 control-label" for="input-height"><?php echo $entry_height; ?></label>
                        <div class="col-sm-2">
                            <input type="text" name="height" value="<?php echo $height; ?>" placeholder="<?php echo $entry_height; ?>" id="input-height" class="form-control" />
                            <?php if ($error_height) { ?>
                            <div class="text-danger"><?php echo $error_height; ?></div>
                            <?php } ?>
                            <span class="help-block hidden-lg"><?php echo $text_note_width;?></span>
                        </div>
                        <label class="col-sm-1 control-label" for="input-zoom"><?php echo $entry_zoom; ?></label>
                        <div class="col-sm-2">
                            <select name="zoom" id="input-zoom" class="form-control" onchange="changeZoom()">
                                <?php for ($j = 0; $j <= 19; $j++) { ?>
                                    <option <?php echo $zoom==$j?'selected="selected"':''; ?> value="<?php echo $j;?>"><?php echo $j; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-sm-4 text-right visible-lg"><?php echo $text_note_width;?></div>
                        <div class="col-sm-3 text-right visible-lg"><?php echo $text_note_width;?></div>
                    </div>
                    <div class="form-group row">
                        <div class="col-md-12">
                            <fieldset>
                                <legend><?php echo $text_locations;?> <small class='label label-info'><?php echo $note_refresh_map;?></small></legend>
                                <div class="table-responsive">
                                    <table id="location" class="table table-striped table-bordered table-hover" style="min-width: 900px;">
                                        <thead>
                                            <tr>
                                                <td class="text-left"><?php echo $entry_latitude; ?></td>
                                                <td class="text-left"><?php echo $entry_longitude; ?></td>
                                                <td class="text-left"><?php echo $entry_address; ?></td>
                                                <td class="text-left"><?php echo $entry_icon; ?></td>
                                                <td class="text-left"><?php echo $entry_popup_width; ?></td>
                                                <td></td>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $location_row = 0; ?>
                                            <?php foreach($locations as $loc): ?>
                                            <tr id="location-row<?php echo $location_row;?>">
                                                <td class="text-left" style="width: 12%;"><input type="text" name="locations[<?php echo $location_row;?>][latitude]" value="<?php echo $loc['latitude'];?>" placeholder="<?php echo $entry_latitude; ?>" class="form-control" /></td>
                                                <td class="text-left" style="width: 12%;"><input type="text" name="locations[<?php echo $location_row;?>][longitude]" value="<?php echo $loc['longitude'];?>" placeholder="<?php echo $entry_longitude; ?>" class="form-control" /></td>
                                                <td class="text-left" style="width: 35%;"><textarea name="locations[<?php echo $location_row;?>][address]" placeholder="<?php echo $entry_address; ?>" class="form-control"><?php echo $loc['address'];?></textarea></td>
                                                <td class="text-left" style="width: 26%;">
                                                <div class="row">
                                                    <div class="col-md-8">
                                                    <select class="form-control" name="locations[<?php echo $location_row;?>][icon_url]" onchange="fixIconURL(this)">
                                                        <option value="https://maps.gstatic.com/mapfiles/api-3/images/spotlight-poi.png">Default</option>
                                                        <?php
                                                        foreach ($icons_url as $url => $name) {
                                                            echo '<option value="'.$url.'" '.($loc['icon_url'] == $url ? 'selected="selected"' : '').' >'.$name.'</option>';
                                                        }
                                                        ?>
                                                    </select>
                                                    </div>
                                                <div class="col-md-4"><img src="<?php echo $loc['icon_url'];?>"/></div>
                                                </div>
                                                </td>
                                                <td class="text-left" style="width: 15%;"><input type="text" name="locations[<?php echo $location_row;?>][popup_width]" value="<?php echo $loc['popup_width'];?>" placeholder="<?php echo $entry_popup_width; ?>" class="form-control" /></td>
                                                <td class="text-left"><button type="button" onclick="$('#location-row<?php echo $location_row;?>').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>
                                            </tr>
                                            <?php $location_row++; endforeach;?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="5"></td>
                                                <td class="text-left"><button type="button" onclick="addLocation();" data-toggle="tooltip" title="<?php echo $text_add_location; ?>" class="btn btn-primary"><i class="fa fa-plus-circle"></i></button></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </fieldset>
                        </div>
                    </div>
                </form>
                <div class="text-right">
                	<button type="button" class="btn pull-right btn-primary" onclick="updateMarkers()"><?php echo $text_refresh_map;?></button>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div id="map"></div>
                        <div id="map-directions"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<style type="text/css">
#map {
    height: <?php echo $height; ?>;
    width: <?php echo $width; ?>;
}
</style>
<script type="text/javascript"><!--
var location_row = <?php echo $location_row; ?>;

function addLocation() {
    html  = '<tr id="location-row' + location_row + '">';
    html += '  <td class="text-left" style="width: 12%;"><input type="text" name="locations[' + location_row + '][latitude]" value="" placeholder="<?php echo $entry_latitude; ?>" class="form-control" /></td>';
    html += '  <td class="text-left" style="width: 12%;"><input type="text" name="locations[' + location_row + '][longitude]" value="" placeholder="<?php echo $entry_longitude; ?>" class="form-control" /></td>';
    html += '  <td class="text-left" style="width: 35%;"><textarea name="locations[' + location_row + '][address]" placeholder="<?php echo $entry_address; ?>" class="form-control"></textarea></td>';
    html += '  <td class="text-left" style="width: 26%;"><div class="row"> <div class="col-md-8"> <select class="form-control" name="locations[' + location_row + '][icon_url]" onchange="fixIconURL(this)"><option value="https://maps.gstatic.com/mapfiles/api-3/images/spotlight-poi.png">Default</option><?php foreach ($icons_url as $url => $name) { echo '<option value="'.$url.'">'.$name.'</option>'; } ?> </select> </div> <div class="col-md-4"><img src="https://maps.gstatic.com/mapfiles/api-3/images/spotlight-poi.png"/></div></div></td>';
    html += '  <td class="text-left" style="width: 15%;"><input type="text" name="locations[' + location_row + '][popup_width]" value="" placeholder="<?php echo $entry_popup_width; ?>" class="form-control" /></td>';
    html += '  <td class="text-left"><button type="button" onclick="$(\'#location-row' + location_row + '\').remove();" data-toggle="tooltip" title="<?php echo $button_remove; ?>" class="btn btn-danger"><i class="fa fa-minus-circle"></i></button></td>';
    html += '</tr>';
    $('#location tbody').append(html);
    location_row++;
}
var markers = {};
var currentPosition = {};
var currentMarker = null;
var map;
var bounds;
var zoom = <?php echo $zoom; ?>;
var geocoder;
var currentNotSupport = false;
function initMap() {
    map = new google.maps.Map(document.getElementById('map'), {
        zoom: <?php echo $zoom; ?>,
        center: {lat: 52.520, lng: 13.410}
    });
    zoomChangeBoundsListener = google.maps.event.addListenerOnce(map, 'bounds_changed', function(event) {
        if (this.getZoom()){
            this.setZoom(zoom);
        }
    });
    updateMarkers();
}
function updateMarkers() {
    bounds = new google.maps.LatLngBounds();
    var isChange = false;
    jQuery('#location tbody > tr').each(function(key, tr){
        id = jQuery(tr).attr('id').toString().replace('location-row', '');
        latitude = jQuery('input[name="locations\[' + id + '\]\[latitude\]"]').val();
        longitude = jQuery('input[name="locations\[' + id + '\]\[longitude\]"]').val();
        address = jQuery('textarea[name="locations\[' + id + '\]\[address\]"]').val();
        icon_url = jQuery('select[name="locations\[' + id + '\]\[icon_url\]"]').val();
        popup_width = jQuery('input[name="locations\[' + id + '\]\[popup_width\]"]').val();
        if(typeof(latitude) != 'undefined' && typeof(longitude) != 'undefined' && latitude != '' && longitude != '') {
            isChange = true;

            var latLng = new google.maps.LatLng(parseFloat(latitude), parseFloat(longitude));
            if (typeof(markers[id]) != 'undefined') {
                markers[id].setMap(null);
            }
            markers[id] = new google.maps.Marker({
                position: latLng,
                map: map,
                icon : icon_url,
                animation: google.maps.Animation.DROP
            });
            var infowindow = new google.maps.InfoWindow({
                content: address,
                maxWidth: popup_width || 700
            });
            google.maps.event.addListener(markers[id], 'click', function() {
                infowindow.open(map, this);
            });
            bounds.extend(latLng);
        }
    });
    if(isChange) {
        map.fitBounds(bounds);
    }
    //map.setZoom(zoom);
}
function changeZoom() {
    zoom = parseInt(jQuery('#input-zoom').val());
    map.setZoom(zoom);
    google.maps.event.trigger(map, 'resize');
}
function changeSize() {
    jQuery('#map').width(jQuery('#input-width').val()).height(jQuery('#input-height').val());
    google.maps.event.trigger(map, 'resize');
}

function fixIconURL(select) {
    jQuery('img', jQuery(select).parent().parent()).attr('src', jQuery(select).val());
}
jQuery(document).ready(function($) {
    jQuery('#input-width,#input-height').blur(function(event) {
        changeSize();
    });
});
-->
</script>
<script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAOSlm0CI0Iu2GoS7qeNTmeiP4lvdHFGKM&callback=initMap"></script>
<?php echo $footer; ?>