<?php
class ControllerModuleMasterGoogleMaps extends Controller {
	private $error = array();
	private function fixMapSizeValue($size) {
		$lastCh = substr($size, -1);
		return $lastCh == '%' || $lastCh == 'x' ? $size : $size . 'px';
	}
	public function index() {

		if(version_compare(VERSION, '2.2.0.0', '<') == true) {
		    $ssl_val = 'SSL';
		} else {
		    $ssl_val = true;
		}

		$this->load->language('module/master_google_maps');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('extension/module');

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->request->post['width'] = $this->fixMapSizeValue($this->request->post['width']);
			$this->request->post['height'] = $this->fixMapSizeValue($this->request->post['height']);
			foreach ($this->request->post['locations'] as $key=>$item) {
				$this->request->post['locations'][$key]['popup_width'] = trim(trim($item['popup_width'], 'px'), '%');
				if(empty($item['latitude']) && empty($item['longitude'])) {
					unset($this->request->post['locations'][$key]);
				}
			}
			$this->session->data['success'] = $this->language->get('text_success');
			if (!isset($this->request->get['module_id'])) {
				$this->model_extension_module->addModule('master_google_maps', $this->request->post);
				$this->response->redirect($this->url->link('extension/module', 'token=' . $this->session->data['token'], $ssl_val));
			} else {
				$this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);
				$this->response->redirect($this->url->link('module/master_google_maps', 'module_id='.$this->request->get['module_id'].'&token=' . $this->session->data['token'], $ssl_val));
			}
		}
		$data['icons_url'] = $this->getIconsUrl();
		$data['heading_title'] = $this->language->get('heading_title');

		$data['note_refresh_map'] = $this->language->get('note_refresh_map');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_locations'] = $this->language->get('text_locations');
		$data['text_note_width'] = $this->language->get('text_note_width');
		$data['text_add_location'] = $this->language->get('text_add_location');
		$data['text_refresh_map'] = $this->language->get('text_refresh_map');
		$data['text_yourlocation'] = $this->language->get('text_yourlocation');
		$data['text_loading'] = $this->language->get('text_loading');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');

		$data['entry_name'] = $this->language->get('entry_name');
		$data['entry_zoom'] = $this->language->get('entry_zoom');
		$data['entry_width'] = $this->language->get('entry_width');
		$data['entry_height'] = $this->language->get('entry_height');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_latitude'] = $this->language->get('entry_latitude');
		$data['entry_longitude'] = $this->language->get('entry_longitude');
		$data['entry_address'] = $this->language->get('entry_address');
		$data['entry_icon'] = $this->language->get('entry_icon');
		$data['entry_popup_width'] = $this->language->get('entry_popup_width');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_remove'] = $this->language->get('button_remove');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['name'])) {
			$data['error_name'] = $this->error['name'];
		} else {
			$data['error_name'] = '';
		}

		if (isset($this->error['width'])) {
			$data['error_width'] = $this->error['width'];
		} else {
			$data['error_width'] = '';
		}

		if (isset($this->error['height'])) {
			$data['error_height'] = $this->error['height'];
		} else {
			$data['error_height'] = '';
		}
		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], $ssl_val)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_module'),
			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], $ssl_val)
		);

		if (!isset($this->request->get['module_id'])) {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/master_google_maps', 'token=' . $this->session->data['token'], $ssl_val)
			);
		} else {
			$data['breadcrumbs'][] = array(
				'text' => $this->language->get('heading_title'),
				'href' => $this->url->link('module/master_google_maps', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], $ssl_val)
			);
		}

		if (!isset($this->request->get['module_id'])) {
			$data['action'] = $this->url->link('module/master_google_maps', 'token=' . $this->session->data['token'], $ssl_val);
		} else {
			$data['action'] = $this->url->link('module/master_google_maps', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], $ssl_val);
		}

		$data['cancel'] = $this->url->link('extension/module', 'token=' . $this->session->data['token'], $ssl_val);

		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {
			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);
		}

		if (isset($this->request->post['name'])) {
			$data['name'] = $this->request->post['name'];
		} elseif (!empty($module_info)) {
			$data['name'] = $module_info['name'];
		} else {
			$data['name'] = '';
		}

		if (isset($this->request->post['width'])) {
			$data['width'] = $this->request->post['width'];
		} elseif (!empty($module_info)) {
			$data['width'] = $module_info['width'];
		} else {
			$data['width'] = '100%';
		}

		if (isset($this->request->post['height'])) {
			$data['height'] = $this->request->post['height'];
		} elseif (!empty($module_info)) {
			$data['height'] = $module_info['height'];
		} else {
			$data['height'] = '600px';
		}

		if (isset($this->request->post['zoom'])) {
			$data['zoom'] = $this->request->post['zoom'];
		} elseif (!empty($module_info) && !empty($module_info['zoom'])) {
			$data['zoom'] = $module_info['zoom'];
		} else {
			$data['zoom'] = 12;
		}

		if (isset($this->request->post['locations'])) {
			$data['locations'] = $this->request->post['locations'];
		} elseif (!empty($module_info) && !empty($module_info['locations'])) {
			$data['locations'] = $module_info['locations'];
		} else {
			$data['locations'] = array();
		}

		if (isset($this->request->post['status'])) {
			$data['status'] = $this->request->post['status'];
		} elseif (!empty($module_info)) {
			$data['status'] = $module_info['status'];
		} else {
			$data['status'] = '';
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		if(version_compare(VERSION, '2.2.0.0', '<') == true) {
		    $this->response->setOutput($this->load->view('module/master_google_maps.tpl', $data));
		} else {
		    $this->response->setOutput($this->load->view('module/master_google_maps', $data));
		}
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'module/master_google_maps')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {
			$this->error['name'] = $this->language->get('error_name');
		}

		if (!$this->request->post['width']) {
			$this->error['width'] = $this->language->get('error_width');
		}

		if (!$this->request->post['height']) {
			$this->error['height'] = $this->language->get('error_height');
		}

		return !$this->error;
	}

	private function getIconsUrl() {
		return array(
			'https://maps.gstatic.com/mapfiles/ms2/micons/blue-dot.png' => 'Blue Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/red-dot.png' => 'Red Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/green-dot.png' => 'Green Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/ltblue-dot.png' => 'Light Blue Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/yellow-dot.png' => 'Yellow Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/purple-dot.png' => 'Purple Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/pink-dot.png' => 'Pink Dot',
			'https://maps.gstatic.com/mapfiles/ms2/micons/blue-pushpin.png' => 'Blue PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/red-pushpin.png' => 'Red PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/grn-pushpin.png' => 'Green PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/ltblu-pushpin.png' => 'Light Blue PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/ylw-pushpin.png' => 'Yello PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/purple-pushpin.png' => 'Purple PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/pink-pushpin.png' => 'Pink PushPin',
			'https://maps.gstatic.com/mapfiles/ms2/micons/restaurant.png' => 'Retautant',
			'https://maps.gstatic.com/mapfiles/ms2/micons/coffeehouse.png' => 'Coffee House',
			'https://maps.gstatic.com/mapfiles/ms2/micons/bar.png' => 'Bar',
			'https://maps.gstatic.com/mapfiles/ms2/micons/snack_bar.png' => 'Snack Bar',
			'https://maps.gstatic.com/mapfiles/ms2/micons/man.png' => 'Man',
			'https://maps.gstatic.com/mapfiles/ms2/micons/woman.png' => 'Woman',
			'https://maps.gstatic.com/mapfiles/ms2/micons/wheel_chair_accessible.png' => 'Wheel Chair',
			'https://maps.gstatic.com/mapfiles/ms2/micons/parkinglot.png' => 'Parking',
			'https://maps.gstatic.com/mapfiles/ms2/micons/cabs.png' => 'Cabs',
			'https://maps.gstatic.com/mapfiles/ms2/micons/bus.png' => 'Bus',
			'https://maps.gstatic.com/mapfiles/ms2/micons/truck.png' => 'Truck',
			'https://maps.gstatic.com/mapfiles/ms2/micons/rail.png' => 'Rail',
			'https://maps.gstatic.com/mapfiles/ms2/micons/plane.png' => 'Plane',
			'https://maps.gstatic.com/mapfiles/ms2/micons/ferry.png' => 'Ferry',
			'https://maps.gstatic.com/mapfiles/ms2/micons/helicopter.png' => 'Helicopter',
			'https://maps.gstatic.com/mapfiles/ms2/micons/subway.png' => 'Subway',
			'https://maps.gstatic.com/mapfiles/ms2/micons/tram.png' => 'Tram',
			'https://maps.gstatic.com/mapfiles/ms2/micons/info.png' => 'Info',
			'https://maps.gstatic.com/mapfiles/ms2/micons/info_circle.png' => 'Info Circle',
			'https://maps.gstatic.com/mapfiles/ms2/micons/flag.png' => 'Flag',
			'https://maps.gstatic.com/mapfiles/ms2/micons/rainy.png' => 'Rainy',
			'https://maps.gstatic.com/mapfiles/ms2/micons/water.png' => 'Water',
			'https://maps.gstatic.com/mapfiles/ms2/micons/snowflake_simple.png' => 'Snowflake',
			'https://maps.gstatic.com/mapfiles/ms2/micons/marina.png' => 'Marine',
			'https://maps.gstatic.com/mapfiles/ms2/micons/fishing.png' => 'Fishing',
			'https://maps.gstatic.com/mapfiles/ms2/micons/sailing.png' => 'Sailing',
			'https://maps.gstatic.com/mapfiles/ms2/micons/swimming.png' => 'Swimming',
			'https://maps.gstatic.com/mapfiles/ms2/micons/ski.png' => 'Ski',
			'https://maps.gstatic.com/mapfiles/ms2/micons/tree.png' => 'Tree',
			'https://maps.gstatic.com/mapfiles/ms2/micons/campfire.png' => 'Campfire',
			'https://maps.gstatic.com/mapfiles/ms2/micons/picnic.png' => 'Picnic',
			'https://maps.gstatic.com/mapfiles/ms2/micons/campground.png' => 'Campground',
			'https://maps.gstatic.com/mapfiles/ms2/micons/rangerstation.png' => 'Ranger Station',
			'https://maps.gstatic.com/mapfiles/ms2/micons/toilets.png' => 'Toilets',
			'https://maps.gstatic.com/mapfiles/ms2/micons/POI.png' => 'Point of Interest',
			'https://maps.gstatic.com/mapfiles/ms2/micons/hiker.png' => 'Hiker',
			'https://maps.gstatic.com/mapfiles/ms2/micons/cycling.png' => 'Cycling',
			'https://maps.gstatic.com/mapfiles/ms2/micons/motorcycling.png' => 'Motorcycling',
			'https://maps.gstatic.com/mapfiles/ms2/micons/horsebackriding.png' => 'Horseback Riding',
			'https://maps.gstatic.com/mapfiles/ms2/micons/sportvenue.png' => 'Sport Venue',
			'https://maps.gstatic.com/mapfiles/ms2/micons/golfer.png' => 'Golfer',
			'https://maps.gstatic.com/mapfiles/ms2/micons/trail.png' => 'Trail',
			'https://maps.gstatic.com/mapfiles/ms2/micons/shopping.png' => 'Shopping',
			'https://maps.gstatic.com/mapfiles/ms2/micons/movies.png' => 'Movies',
			'https://maps.gstatic.com/mapfiles/ms2/micons/grocerystore.png' => 'Grocery Store',
			'https://maps.gstatic.com/mapfiles/ms2/micons/convienancestore.png' => 'Convienance Store',
			'https://maps.gstatic.com/mapfiles/ms2/micons/arts.png' => 'Arts',
			'https://maps.gstatic.com/mapfiles/ms2/micons/homegardenbusiness.png' => 'Home Garden Business',
			'https://maps.gstatic.com/mapfiles/ms2/micons/electronics.png' => 'Electronics',
			'https://maps.gstatic.com/mapfiles/ms2/micons/mechanic.png' => 'Mechanic',
			'https://maps.gstatic.com/mapfiles/ms2/micons/gas.png' => 'Gas',
			'https://maps.gstatic.com/mapfiles/ms2/micons/realestate.png' => 'Real Estate',
			'https://maps.gstatic.com/mapfiles/ms2/micons/salon.png' => 'Salon',
			'https://maps.gstatic.com/mapfiles/ms2/micons/dollar.png' => 'Dollar',
			'https://maps.gstatic.com/mapfiles/ms2/micons/euro.png' => 'Euro',
			'https://maps.gstatic.com/mapfiles/ms2/micons/yen.png' => 'Yen',
			'https://maps.gstatic.com/mapfiles/ms2/micons/firedept.png' => 'Fire Department',
			'https://maps.gstatic.com/mapfiles/ms2/micons/hospitals.png' => 'Hospitals',
			'https://maps.gstatic.com/mapfiles/ms2/micons/lodging.png' => 'Lodging',
			'https://maps.gstatic.com/mapfiles/ms2/micons/phone.png' => 'Phone',
			'https://maps.gstatic.com/mapfiles/ms2/micons/caution.png' => 'Caution',
			'https://maps.gstatic.com/mapfiles/ms2/micons/earthquake.png' => 'Earthquake',
			'https://maps.gstatic.com/mapfiles/ms2/micons/fallingrocks.png' => 'Falling Rocks',
			'https://maps.gstatic.com/mapfiles/ms2/micons/postoffice-us.png' => 'Post Office',
			'https://maps.gstatic.com/mapfiles/ms2/micons/police.png' => 'Police',
			'https://maps.gstatic.com/mapfiles/ms2/micons/sunny.png' => 'Sunny',
			'https://maps.gstatic.com/mapfiles/ms2/micons/partly_cloudy.png' => 'Partly Cloudy',
			'https://maps.gstatic.com/mapfiles/ms2/micons/volcano.png' => 'Volcano',
			'https://maps.gstatic.com/mapfiles/ms2/micons/camera.png' => 'Camera',
			'https://maps.gstatic.com/mapfiles/ms2/micons/webcam.png' => 'Webcam'
			);
	}
}