<?php

//                  (c) 2017 IZYUM WEB SYSTEM www.izyum.name 

class ControllerExtensionModuleIwsmap extends Controller {



	private $error = array();



	public function index() {

		$this->load->model('extension/module');

		$this->load->model('setting/setting');

		$this->load->language('extension/module/iwsmap');

		$this->document->setTitle($this->language->get('heading_title'));



		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			if (!isset($this->request->get['module_id'])) {

				$this->model_extension_module->addModule('iwsmap', $this->request->post);

			} else {

				$this->model_extension_module->editModule($this->request->get['module_id'], $this->request->post);

			}

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL'));

		}

		$data['button_cancel']     = $this->language->get('button_cancel');

		$data['button_save']       = $this->language->get('button_save');

		$data['entry_name']        = $this->language->get('entry_name');

		$data['entry_status']      = $this->language->get('entry_status');

		$data['heading_title']     = $this->language->get('heading_title');

		$data['text_disabled']     = $this->language->get('text_disabled');

		$data['text_edit']         = $this->language->get('text_edit');

		$data['text_enabled']      = $this->language->get('text_enabled');

		//                    Google Maps

		$data['button_add_module'] = $this->language->get('button_add_module');

		$data['button_add_punkt']  = $this->language->get('button_add_punkt');

		$data['button_cancel']     = $this->language->get('button_cancel');

		$data['button_remove']     = $this->language->get('button_remove');

		$data['button_save']       = $this->language->get('button_save');

		$data['entry_iwsadr']      = $this->language->get('entry_iwsadr');

		$data['entry_iwsadrsort']      = $this->language->get('entry_iwsadrsort');

		$data['entry_iwslat']      = $this->language->get('entry_iwslat');

		$data['entry_iwslon']      = $this->language->get('entry_iwslon');

		$data['entry_iwstimework'] = $this->language->get('entry_iwstimework');

		$data['entry_iwssort']     = $this->language->get('entry_iwssort');

		$data['entry_iwstown']     = $this->language->get('entry_iwstown');

		$data['entry_keyapi']      = $this->language->get('entry_keyapi');

		$data['entry_coord']       = $this->language->get('entry_coord');

		$data['error_iwsadr']      = $this->language->get('error_iwsadr');

		$data['error_iwsadrsort']      = $this->language->get('error_iwsadrsort');

		$data['error_iwslat']      = $this->language->get('error_iwslat');

		$data['error_iwslon']      = $this->language->get('error_iwslon');

		$data['error_iwsmod']      = $this->language->get('error_iwsmod');

		$data['error_iwstimework'] = $this->language->get('error_iwstimework');

		$data['error_iwstown']     = $this->language->get('error_iwstown');

		$data['error_iwssort']     = $this->language->get('error_iwssort');


		if (isset($this->error['warning'])) {

			$data['error_warning'] = $this->error['warning'];

		} else {

			$data['error_warning'] = '';

		}



		if (isset($this->error['name'])) {

			$data['error_name'] = $this->error['name'];

		} else {

			$data['error_name'] = '';

		}



		if (isset($this->error['keyapi'])) {

			$data['error_keyapi'] = $this->error['keyapi'];

		} else {

			$data['error_keyapi'] = '';

		}



		$data['breadcrumbs'] = array();



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('text_home'),

			'href' => $this->url->link('common/dashboard', 'token=' . $this->session->data['token'], 'SSL')

			);



		$data['breadcrumbs'][] = array(

			'text' => $this->language->get('text_module'),

			'href' => $this->url->link('extension/module', 'token=' . $this->session->data['token'], 'SSL')

			);



		if (!isset($this->request->get['module_id'])) {

			$data['breadcrumbs'][] = array(

				'text' => $this->language->get('heading_title'),

				'href' => $this->url->link('extension/module/iwsmap', 'token=' . $this->session->data['token'], 'SSL')

				);

		} else {

			$data['breadcrumbs'][] = array(

				'text' => $this->language->get('heading_title'),

				'href' => $this->url->link('extension/module/iwsmap', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL')

				);

		}



		if (!isset($this->request->get['module_id'])) {

			$data['action'] = $this->url->link('extension/module/iwsmap', 'token=' . $this->session->data['token'], 'SSL');

		} else {

			$data['action'] = $this->url->link('extension/module/iwsmap', 'token=' . $this->session->data['token'] . '&module_id=' . $this->request->get['module_id'], 'SSL');

		}



		$data['cancel'] = $this->url->link('extension/extension', 'token=' . $this->session->data['token'], 'SSL');



		if (isset($this->request->get['module_id']) && ($this->request->server['REQUEST_METHOD'] != 'POST')) {

			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);

		}



		$data['token'] = $this->session->data['token'];



		if (isset($this->request->post['name'])) {

			$data['name'] = $this->request->post['name'];

		} elseif (!empty($module_info)) {

			$data['name'] = $module_info['name'];

		} else {

			$data['name'] = '';

		}



		if (isset($this->request->post['status'])) {

			$data['status'] = $this->request->post['status'];

		} elseif (!empty($module_info)) {

			$data['status'] = $module_info['status'];

		} else {

			$data['status'] = '';

		}





		if (isset($this->request->post['keyapi'])) {

			$data['keyapi'] = $this->request->post['keyapi'];

		} elseif (!empty($module_info)) {

			$data['keyapi'] = $module_info['keyapi'];

		} else {

			$data['keyapi'] = '';

		}



		//Error in table 

		if (isset($this->error['dimension'])) {

			$data['error_dimension'] = $this->error['dimension'];

		} else {

			$data['error_dimension'] = array();

		}



		// Output table form oc_module

		if (isset($this->request->get['module_id'])) {

			$module_info = $this->model_extension_module->getModule($this->request->get['module_id']);

			$data['modulegeo'] = $module_info;

		}

		$data['header'] = $this->load->controller('common/header');

		$data['column_left'] = $this->load->controller('common/column_left');

		$data['footer'] = $this->load->controller('common/footer');



		$this->response->setOutput($this->load->view('extension/module/iwsmap.tpl', $data));

	}



	protected function validate() {

		if (!$this->user->hasPermission('modify', 'extension/module/iwsmap')) {

			$this->error['warning'] = $this->language->get('error_permission');

		}



		if ((utf8_strlen($this->request->post['name']) < 3) || (utf8_strlen($this->request->post['name']) > 64)) {

			$this->error['name'] = $this->language->get('error_name');

		}



		if (!(utf8_strlen($this->request->post['keyapi']))) {

			$this->error['keyapi'] = $this->language->get('error_keyapi');

		}



		if (isset($this->request->post['iwsmap_modulegeo'])) {

			foreach ($this->request->post['iwsmap_modulegeo'] as $key => $value) {
					


				if (!$value['iwstown']) {

					$this->error['dimension'][0] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwstown');

				}

				if (!$value['iwsadr']) {

					$this->error['dimension'][1] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwsadr');

				}

				if (!$value['iwslon']) {

					$this->error['dimension'][2] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwslon');

				}

				if (!$value['iwslat']) {

					$this->error['dimension'][3] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwslat');

				}

				if (!$value['iwstimework']) {

					$this->error['dimension'][4] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwstimework');

				}

				if (!$value['iwssort']) {

					$this->error['dimension'][5] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwssort');

				}

				if (!$value['iwsadrsort']) {

					$this->error['dimension'][6] = $this->language->get('error_iwsmod') . ' ' . $this->language->get('entry_iwsadrsort');

				}

			} 

		}

		return !$this->error;

	}

}

